/*
=======================================================================================
'N?vel Classifica??o.: INFORMA??O RESTRITA
'Vers?o..............: 202203311000
'Job.................:  
'Nome................: 
'Objetivo............: Alteração de tamanho do campo obs - Postgresql
'Tabelas.............: est_orc 
'Dt Cria??o..........: 31/03/2022
'Criado por..........: Lucas Mário Bischoff
'Dt Ult Alterac?o....: -- 
'Alterado por........: --

'=======================================================================================
-- https://jira.linx.com.br/browse/FARMAGOI-28236
*/
create or replace function addcolumn()
returns void as
$body$
begin



IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc' AND COLUMN_NAME = 'obs') THEN
DROP VIEW public.v_orcamento;

ALTER TABLE public.est_orc
    ALTER COLUMN obs TYPE character varying(2000) COLLATE pg_catalog."default";

CREATE OR REPLACE VIEW public.v_orcamento
 AS
 SELECT orc.cd_emp,
    orc.cd_filial,
    orc.cd_orc,
    orc.dt_emi,
    orc.hr_emi,
    orc.nr_ped_televd AS nr_pedido,
    orc.vlr_tot,
        CASE
            WHEN COALESCE(orc.cd_conv::numeric, 0::numeric) <> 0::numeric THEN 1
            ELSE NULL::integer
        END AS contem_convenio,
    COALESCE(cli_conv.ds_conv, ''::character varying) AS ds_conv,
        CASE
            WHEN COALESCE(orc.tipo_pbm::numeric, '-1'::integer::numeric) <> '-1'::integer::numeric THEN 1
            ELSE NULL::integer
        END AS contem_pbm,
        CASE
            WHEN orc.tp_orc_entg = 1::numeric THEN 1
            ELSE NULL::integer
        END AS contem_entrega,
        CASE
            WHEN receita.nr_orc IS NOT NULL THEN 1
            ELSE NULL::integer
        END AS contem_receita,
    COALESCE(receita.cd_medico_rec, 0) AS medico_id,
    medico.nm_medico AS medico_nm,
    medico.cd_tp_doc AS medico_tp_doc,
    medico.nr_doc AS medico_nr_doc,
    medico.uf_doc AS medico_uf_doc,
    COALESCE(receita.nr_receita, 0::bigint) AS numero_receita,
    COALESCE(receita.cd_receita, 0) AS codigo_receita,
    receita.dt_receita,
    receita.tp_capt_receita AS tipo_captacao_receita,
    orc.cd_cli,
    orc.nm_cli,
    cli.cgc_cpf AS cli_cgccpf,
    orc.nr_cartao_fidelidade AS nr_cartao_cli,
    orc.fone_cli,
    orc.nm_comprador,
    orc.tp_orc,
    orc.tipo_prazo_pgto AS tp_prazo_pgto,
    orc.cd_frm_pgto AS cd_forma_pgto,
    orc.orig_orc AS origem_orc,
    orc.vd_troca_fidel,
    orc.sts_orc,
    orc.obs,
    orc.dados_adicionais,
    orc.offline,
    COALESCE(orc.flag_consolidado, 0) AS flag_consolidado,
    cpl.cd_prod,
    NULL::character varying AS ds_prod,
    cpl.qt AS qt_it,
    cpl.vlr_it,
    cpl.vlr_tot_it,
    cpl.vlr_desc,
    COALESCE(cpl.perc_desc, 0::numeric) AS "coalesce",
    cpl.cd_vend,
    NULL::character varying AS nm_vend,
    orc.cd_vend_lib AS vend_lib,
    NULL::character varying AS vend_lib_nm,
    cpl.pr_tab AS vlr_it_tab,
    cpl.oferta AS is_oferta_it,
    cpl.perc_desc_cad,
    cpl.perc_desc_fix,
    cpl.vlr_desc_fix,
    cpl.tipo_desconto AS tp_desc,
    cpl.qtde_ponto_fidel AS qt_pontos_fidel,
    cpl.vlr_economia,
    cpl.vlr_desc_verba,
    cpl.perc_desc_verba,
    cpl.cd_vend_verba,
    NULL::character varying AS nm_vend_verba,
    cpl.libera_vd_conv,
    cpl.vlr_custo_semaforo,
    cpl.qt_est,
    cpl.cd_grp AS cd_grupo_comissao,
    cpl.nr_protocolo_manipulado,
    cpl.perc_desconto_pos_pbm,
    desconto_concorrente.cd_concor AS cd_concorrente,
    desconto_concorrente.vlr_concor AS vlr_concorrente,
        CASE
            WHEN COALESCE(est_cancel.cd_mt_cancel_orc, 0) > 0 THEN true
            ELSE false
        END AS orcamento_cancel,
    COALESCE(est_cancel.cd_mt_cancel_orc, 0) AS codigomotivocancel,
    est_cancel.desc_mt_cancel AS descricaomotivocancel,
    lote.cd_lote,
    lote.qtde_lote,
    receita.nm_comprador AS nm_comprador_rec,
    receita.idade AS idade_rec,
    receita.nm_paciente AS nm_paciente_rec,
    receita.receita_tipo AS receita_tipo_rec,
    COALESCE(receita.cid, 0) AS cid_rec,
    receita.uf AS uf_rec,
    receita.nr_doc_cli AS nr_doc_cli_rec,
    receita.tipo_documento AS tipo_documento_rec,
    cpl.venda_dependente,
    cpl.cd_it
   FROM est_orc orc
     JOIN est_orc_cpl cpl ON orc.cd_emp::numeric = cpl.cd_emp AND orc.cd_filial::numeric = cpl.cd_filial AND orc.cd_orc::numeric = cpl.cd_orc
     JOIN rc_cli cli ON orc.cd_emp::numeric = cli.cd_emp AND orc.cd_cli::numeric = cli.cd_cli
     LEFT JOIN rc_cli_conv cli_conv ON orc.cd_conv::numeric = cli_conv.cd_conv AND orc.cd_emp::numeric = cli_conv.cd_emp
     LEFT JOIN est_orc_glb_medico receita ON cpl.cd_emp = receita.cd_emp::numeric AND cpl.cd_filial = receita.cd_filial::numeric AND cpl.cd_orc = receita.nr_orc::numeric AND cpl.cd_prod = receita.cd_prod::numeric
     LEFT JOIN glb_medicos medico ON cpl.cd_emp = medico.cd_emp::numeric AND receita.cd_medico_rec = medico.cd_ctr
     LEFT JOIN est_orc_cpl_concor desconto_concorrente ON cpl.cd_emp = desconto_concorrente.cd_emp::numeric AND cpl.cd_filial = desconto_concorrente.cd_filial::numeric AND cpl.cd_orc = desconto_concorrente.nr_orc::numeric
     LEFT JOIN est_orc_mt_cancel est_cancel ON est_cancel.cd_emp::numeric = orc.cd_emp::numeric AND est_cancel.cd_filial::numeric = orc.cd_filial::numeric AND est_cancel.cd_orc::numeric = orc.cd_orc::numeric
     LEFT JOIN est_orc_cpl_lote lote ON cpl.cd_emp = lote.cd_emp AND cpl.cd_filial = lote.cd_filial AND cpl.cd_orc = lote.cd_orc AND cpl.cd_prod = lote.cd_prod;

ALTER TABLE public.v_orcamento
    OWNER TO postgres;

raise notice 'Campo TIPO_CAMPANHA_ADIC adicionado com sucesso !' ;
ELSE
raise notice 'Campo TIPO_CAMPANHA_ADIC já existe na tabela! ';
END IF;



end;
$body$
language plpgsql volatile
cost 100;
alter function addcolumn() owner to postgres;
select addcolumn();
drop function addcolumn();